﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultNetworkPlugin.Controls.Strategy
{
    public interface IEnableICMPRedirectStrategy
    {
        void Write(int num);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class EnableICMPRedirectDefaultStrategy : ICorrespondenceOS, IEnableICMPRedirectStrategy
    {
        public EnableICMPRedirectDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,

#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsVista_SP2,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private string RegName = "EnableICMPRedirect";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion


        public void Write(int num)
        {
            RegistryKey registryKey =
                Registry.LocalMachine.CreateSubKey(
                    @"System\CurrentControlSet\Services\Tcpip\Parameters");

            registryKey.SetValue(RegName, num, RegistryValueKind.DWord);
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.LocalMachine.OpenSubKey(
                    @"System\CurrentControlSet\Services\Tcpip\Parameters");

            return new WFRegistry(@"HKEY LOCAL MACHINE\System\CurrentControlSet\Services\Tcpip\Parameters", RegName,
                                  registryKey.GetValue(RegName, 0), RegistryValueKind.DWord, RegOperation.ValueWrite);
        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> { Read() };
        }

    }

    public class EnableICMPRedirectController
    {
        public EnableICMPRedirectController(EnableICMPRedirect enableICMPRedirect,
                                                         IEnableICMPRedirectStrategy strategy)
        {
            EnableICMPRedirect = enableICMPRedirect;
            Strategy = strategy;
        }

        public EnableICMPRedirect EnableICMPRedirect { get; set; }
        public IEnableICMPRedirectStrategy Strategy { get; set; }

        public void Read()
        {
            EnableICMPRedirect.SetEnableCMPRedirectValue(Convert.ToInt32(Strategy.Read().Value));
        }

        public void Write()
        {
            Strategy.Write(EnableICMPRedirect.GetDisableIPSourceRoutingValue());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }

}
